require "TimedActions/ISBaseTimedAction"

TABAS_ReheatTubWater = ISBaseTimedAction:derive("TABAS_ReheatTubWater")

function TABAS_ReheatTubWater:isValid()
    return self.tfc_Base ~= nil and not self.tfc_Base:isEmpty()
end

function TABAS_ReheatTubWater:waitToStart()
    self.character:faceThisObject(self.tfc_Base.bathObject)
    return self.character:shouldBeTurning()
end

function TABAS_ReheatTubWater:update()
end

function TABAS_ReheatTubWater:start()
    self:setOverrideHandModels(nil, nil)
    self:setActionAnim("Loot")
    self.character:SetVariable("LootPosition", "Middle")
    self.character:reportEvent("EventLootItem")
end

function TABAS_ReheatTubWater:stop()
	ISBaseTimedAction.stop(self)
end

function TABAS_ReheatTubWater:perform()
    self.tfc_Base:triggerActivate('reheat', self.turnOn)

	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function TABAS_ReheatTubWater:adjustMaxTime(maxTime)
    return maxTime
end

function TABAS_ReheatTubWater:new(character, tfc_Base, turnOn)
    local o = ISBaseTimedAction.new(self, character)
    o.tfc_Base = tfc_Base
    o.turnOn = turnOn
    o.maxTime = 20

    o.ignoreHandsWounds = true
    o.useProgressBar = false
    o.caloriesModifier = 0
    return o
end